

#include <stdbool.h>

#define DEFMODBUSADDR		0x01		// default MB address
#define FRAME			40		// max length of TX/RX buffer

//===========================================================================//
#define	READ_HOLDING_REG	0x03	//Read Holding Registers
#define	READ_INPUT_REG		0x04	//Read Input Registers
#define WRITE_HOLDING_REG	0x06	//Preset Single Register
#define PRESET_MUL_REG		0x10	//Preset Multiple Registers
#define REPORT_DEVICE_ID	0x11	//Report Slave ID
//===========================================================================//
// mbdata registers
//===========================================================================//
// input registers 300001+
#define MB_INPUT_UMEAS		0x0000	//measured U in codes
//#define MB_INPUT_UMEASL		0x0001?
#define MB_INPUT_IMEAS		0x0001	//measured I in codes
//#define MB_INPUT_IMEASL		0x0003?
#define MBMAP_STATE		0x0002	//logical inputs state
#define MBMAP_KEYB_STATE	0x0003	//keyboard state
#define MB_INPUT_TSTFLT		0x0004
#define MB_INPUT_MAXADDR	0x0005
//===========================================================================//
// holding registers 400001+
//===========================================================================//
#define MBMAP_MBADDR		0x0000	//MB address	1..247
#define MBMAP_UARTBR		0x0001	//ints baudrate	0..5 (4800, 9600, 19200, 38400, 57600, 115200)
#define MBMAP_RTSDELAY		0x0002	//delay??????	0..255 (ms)
#define MBMAP_PSUTYPE		0x0003	//PSU type	0..8 (8 + test 51.2V/51.2A)
#define MBMAP_PWM_U		0x0004	//pwm val U
//#define MBMAP_PWM_UL	0x0004
#define MBMAP_PWM_I		0x0005	//pwm val I
//#define MBMAP_PWM_IL	0x0006
#define MBMAP_CAL_UIN_ADD	0x0006	//cal data U
//#define MBMAP_CALUINAL 0x0008
#define MBMAP_CAL_UIN_MUL	0x0008	//cal data U
//#define MBMAP_CALUINML 0x000A
#define MBMAP_CAL_IIN_ADD	0x000A	//cal data I
//#define MBMAP_CALIINAL 0x000C
#define MBMAP_CAL_IIN_MUL	0x000C	//cal data I
//#define MBMAP_CALIINML 0x000E

#define MBMAP_STANDBY		0x000E	//stby on/off
//#define MBMAP_CAL_EN
#define MBMAP_MAXVALV		0x000F	//max V
#define MBMAP_MAXVALI		0x0010	//max I

//#define MBMAP_KEYB_DIS
//#define MBMAP_MEAS_FILTER
//#define MBMAP_USERTYPE_UMAX
//#define MBMAP_USERTYPE_IMAX

#define MB_HOLDING_MAXADDR	0x0010	//integer regs
//===========================================================================//


extern unsigned int	uiPosition_Volt,
			uiPosition_Amp;

extern unsigned char	ucPSUTYPE;

extern float		flUcalA,
			flUcalM,
			flIcalA,
			flIcalM;

extern unsigned int	U_PWM_VAL,
			I_PWM_VAL;

extern unsigned int	U_MAX_SETUP_VAL,
			I_MAX_SETUP_VAL;

extern unsigned int	U_MEASED,
			I_MEASED;

extern bool		bStandby,
			bCVmode,
			bCCmode,
			bOVTemp,
			bOVmode,
			bOCmode,
			bOAmode,
			bOBmode;


//extern float	U_MEASED,
//		I_MEASED;

void ModBusInit(void);
void ModBusSpooler(void);